# ⚙️ CONFIGURACIONES DE EJEMPLO

Este archivo contiene configuraciones recomendadas para diferentes perfiles de trading.

## 🔰 PERFIL CONSERVADOR (Recomendado para principiantes)

Características:
- Bajo riesgo
- Stop loss y take profit ajustados
- Capital protegido

```env
INITIAL_CAPITAL=100
RISK_PER_TRADE=1
STOP_LOSS_PERCENT=1.5
TAKE_PROFIT_PERCENT=2
MAX_DAILY_LOSS=5
GRID_LEVELS=10
GRID_RANGE_PERCENT=3
```

Rendimiento esperado: 3-8% mensual
Win rate esperado: 65-75%

---

## ⚖️ PERFIL MODERADO (Balance riesgo/recompensa)

Características:
- Riesgo medio
- Mayor potencial de ganancias
- Balance entre seguridad y rendimiento

```env
INITIAL_CAPITAL=200
RISK_PER_TRADE=2
STOP_LOSS_PERCENT=1.5
TAKE_PROFIT_PERCENT=2.5
MAX_DAILY_LOSS=10
GRID_LEVELS=10
GRID_RANGE_PERCENT=5
```

Rendimiento esperado: 8-15% mensual
Win rate esperado: 60-70%

---

## 🚀 PERFIL AGRESIVO (Solo para traders experimentados)

⚠️ **ADVERTENCIA**: Mayor riesgo de pérdidas significativas

Características:
- Alto riesgo
- Mayor potencial de ganancias
- Requiere monitoreo constante

```env
INITIAL_CAPITAL=500
RISK_PER_TRADE=3
STOP_LOSS_PERCENT=2
TAKE_PROFIT_PERCENT=3
MAX_DAILY_LOSS=15
GRID_LEVELS=15
GRID_RANGE_PERCENT=7
```

Rendimiento esperado: 15-30% mensual
Win rate esperado: 55-65%

---

## 🤖 PERFIL SCALPING (Muchas operaciones rápidas)

Características:
- Muchas operaciones pequeñas
- Requiere alta liquidez
- Mejor en mercados volátiles

```env
INITIAL_CAPITAL=300
RISK_PER_TRADE=1.5
STOP_LOSS_PERCENT=0.8
TAKE_PROFIT_PERCENT=1.2
MAX_DAILY_LOSS=10
GRID_LEVELS=20
GRID_RANGE_PERCENT=2
```

Trades por día: 50-100
Rendimiento esperado: 10-20% mensual

---

## 📊 PERFIL SWING (Operaciones de medio plazo)

Características:
- Pocas operaciones
- Mayor tiempo de retención
- Menor frecuencia de trading

```env
INITIAL_CAPITAL=500
RISK_PER_TRADE=2.5
STOP_LOSS_PERCENT=3
TAKE_PROFIT_PERCENT=5
MAX_DAILY_LOSS=12
GRID_LEVELS=8
GRID_RANGE_PERCENT=10
```

Trades por día: 5-15
Rendimiento esperado: 5-12% mensual

---

## 🎯 PERFIL ESPECÍFICO POR PAR

### Solo Bitcoin (BTC)
```env
TRADING_PAIRS=BTCUSDT
INITIAL_CAPITAL=200
GRID_LEVELS=12
GRID_RANGE_PERCENT=4
```

### Solo Ethereum (ETH)
```env
TRADING_PAIRS=ETHUSDT
INITIAL_CAPITAL=150
GRID_LEVELS=10
GRID_RANGE_PERCENT=5
```

### Diversificado (múltiples pares)
```env
TRADING_PAIRS=BTCUSDT,ETHUSDT,SOLUSDT,BNBUSDT,ADAUSDT
INITIAL_CAPITAL=500
GRID_LEVELS=10
GRID_RANGE_PERCENT=5
```

---

## 🌙 PERFIL NOCTURNO (Para mercados asiáticos)

Características:
- Ajustado para volatilidad nocturna
- Menor riesgo durante baja liquidez

```env
INITIAL_CAPITAL=150
RISK_PER_TRADE=1.5
STOP_LOSS_PERCENT=2
TAKE_PROFIT_PERCENT=2
MAX_DAILY_LOSS=8
GRID_LEVELS=8
GRID_RANGE_PERCENT=4
SUMMARY_INTERVAL_HOURS=6
```

---

## ⚡ PERFIL ALTA VOLATILIDAD

Para mercados con movimientos bruscos:

```env
INITIAL_CAPITAL=250
RISK_PER_TRADE=1
STOP_LOSS_PERCENT=2.5
TAKE_PROFIT_PERCENT=3.5
MAX_DAILY_LOSS=8
GRID_LEVELS=15
GRID_RANGE_PERCENT=8
```

---

## 📱 AJUSTES DE NOTIFICACIONES

### Notificaciones completas
```env
SEND_TRADE_NOTIFICATIONS=true
SEND_ERROR_NOTIFICATIONS=true
SUMMARY_INTERVAL_HOURS=2
```

### Solo resúmenes (recomendado)
```env
SEND_TRADE_NOTIFICATIONS=false
SEND_ERROR_NOTIFICATIONS=true
SUMMARY_INTERVAL_HOURS=4
```

### Mínimas notificaciones
```env
SEND_TRADE_NOTIFICATIONS=false
SEND_ERROR_NOTIFICATIONS=true
SUMMARY_INTERVAL_HOURS=8
```

---

## 🔍 CONFIGURACIÓN RSI

### RSI Estricto (menos operaciones, más selectivo)
```env
RSI_PERIOD=14
RSI_OVERBOUGHT=75
RSI_OVERSOLD=25
```

### RSI Normal (balance)
```env
RSI_PERIOD=14
RSI_OVERBOUGHT=70
RSI_OVERSOLD=30
```

### RSI Relajado (más operaciones)
```env
RSI_PERIOD=14
RSI_OVERBOUGHT=65
RSI_OVERSOLD=35
```

---

## 💡 TIPS PARA ELEGIR TU PERFIL

1. **Principiantes**: Empieza con el perfil CONSERVADOR
2. **Poco capital**: Usa perfil CONSERVADOR o MODERADO
3. **Experiencia media**: Perfil MODERADO
4. **Traders activos**: Perfil SCALPING o AGRESIVO
5. **Tiempo limitado**: Perfil SWING con menos notificaciones

---

## 🔄 CÓMO CAMBIAR DE PERFIL

1. Detén el bot
2. Edita `.env` con los valores del perfil elegido
3. Guarda los cambios
4. Reinicia el bot

```bash
screen -r crypto-bot
# Ctrl+C para detener
nano .env
# Editar configuración
# Ctrl+O, Enter, Ctrl+X para guardar
npm start
```

---

## ⚠️ ADVERTENCIAS IMPORTANTES

- **Backtest primero**: Siempre ejecuta `npm run backtest` antes de usar un nuevo perfil
- **Empieza pequeño**: No importa el perfil, empieza con poco capital
- **Monitorea**: Los primeros días, revisa frecuentemente los resultados
- **Ajusta**: Si los resultados no son los esperados, ajusta los parámetros
- **No te obsesiones**: El trading lleva tiempo, no esperes resultados inmediatos

---

## 📊 TABLA COMPARATIVA

| Perfil | Capital Min | Riesgo | Trades/día | ROI Mensual | Skill Needed |
|--------|-------------|--------|------------|-------------|--------------|
| Conservador | $100 | Bajo | 10-20 | 3-8% | Principiante |
| Moderado | $200 | Medio | 20-40 | 8-15% | Intermedio |
| Agresivo | $500 | Alto | 40-60 | 15-30% | Avanzado |
| Scalping | $300 | Medio | 50-100 | 10-20% | Avanzado |
| Swing | $500 | Medio | 5-15 | 5-12% | Intermedio |

---

💡 **Recuerda**: Estos son perfiles de referencia. Siempre puedes crear tu propia configuración personalizada mezclando diferentes parámetros según tu experiencia y objetivos.
