#!/bin/bash

# Script para cambiar entre Testnet y Mainnet
# ⚠️ CUIDADO: Solo usa Mainnet cuando estés 100% seguro

echo "=========================================="
echo "🔄 CAMBIAR ENTRE TESTNET Y MAINNET"
echo "=========================================="
echo ""

# Leer configuración actual
CURRENT_MODE=$(grep "BYBIT_TESTNET" .env | cut -d'=' -f2)

if [ "$CURRENT_MODE" = "true" ]; then
    echo "📍 Modo actual: TESTNET (Dinero simulado) ✅"
    echo ""
    echo "⚠️  ¿Deseas cambiar a MAINNET (DINERO REAL)?"
    echo "   Solo hazlo si:"
    echo "   - Has probado el bot por varios días en testnet"
    echo "   - Entiendes completamente cómo funciona"
    echo "   - Tienes API keys del MAINNET configuradas"
    echo "   - Estás dispuesto a arriesgar dinero real"
    echo ""
    read -p "¿Continuar? (escribe 'SI' en mayúsculas): " confirm
    
    if [ "$confirm" != "SI" ]; then
        echo "❌ Operación cancelada. Permaneciendo en TESTNET."
        exit 0
    fi
    
    # Verificar que las API keys no sean las del testnet
    if grep -q "testnet" .env; then
        echo ""
        echo "⚠️  ADVERTENCIA: Parece que tienes API keys del testnet"
        echo "   Asegúrate de cambiar a las keys del MAINNET en .env"
        echo ""
        echo "1. Ve a: https://www.bybit.com/app/user/api-management"
        echo "2. Crea nuevas API keys para MAINNET"
        echo "3. Actualiza BYBIT_API_KEY y BYBIT_API_SECRET en .env"
        echo ""
        read -p "¿Ya actualizaste las API keys? (s/n): " -n 1 -r
        echo ""
        
        if [[ ! $REPLY =~ ^[Ss]$ ]]; then
            echo "❌ Operación cancelada. Actualiza las API keys primero."
            exit 0
        fi
    fi
    
    # Cambiar a mainnet
    sed -i 's/BYBIT_TESTNET=true/BYBIT_TESTNET=false/' .env
    
    echo ""
    echo "✅ Cambiado a MAINNET"
    echo ""
    echo "⚠️  RECORDATORIOS IMPORTANTES:"
    echo "   - Empieza con capital pequeño"
    echo "   - Monitorea constantemente los primeros días"
    echo "   - Ten stop loss y take profit bien configurados"
    echo "   - Nunca inviertas más de lo que puedas perder"
    echo ""
    
else
    echo "📍 Modo actual: MAINNET (DINERO REAL) ⚠️"
    echo ""
    echo "¿Deseas volver a TESTNET (simulación)?"
    echo ""
    read -p "¿Continuar? (s/n): " -n 1 -r
    echo ""
    
    if [[ ! $REPLY =~ ^[Ss]$ ]]; then
        echo "❌ Operación cancelada"
        exit 0
    fi
    
    # Cambiar a testnet
    sed -i 's/BYBIT_TESTNET=false/BYBIT_TESTNET=true/' .env
    
    echo ""
    echo "✅ Cambiado a TESTNET"
    echo ""
    echo "Recuerda actualizar las API keys del testnet en .env:"
    echo "https://testnet.bybit.com/app/user/api-management"
    echo ""
fi

echo "=========================================="
echo "🔄 Modo actualizado exitosamente"
echo "=========================================="
echo ""
echo "Para aplicar los cambios, reinicia el bot:"
echo ""
echo "Con screen:"
echo "  screen -r crypto-bot"
echo "  Ctrl+C (detener)"
echo "  npm start (reiniciar)"
echo ""
echo "Con PM2:"
echo "  pm2 restart crypto-bot"
echo ""
