# 🚀 GUÍA DE INSTALACIÓN RÁPIDA

## ⚡ Instalación en 5 minutos

### 1️⃣ Preparar el servidor VPS

```bash
# Conectar por SSH
ssh root@tu-ip-vps

# Actualizar sistema
apt update && apt upgrade -y

# Instalar Node.js 20
curl -fsSL https://deb.nodesource.com/setup_20.x | bash -
apt install -y nodejs

# Verificar instalación
node --version  # Debe mostrar v20.x.x
npm --version   # Debe mostrar v10.x.x

# Instalar screen (para mantener el bot corriendo)
apt install -y screen
```

### 2️⃣ Subir el bot al VPS

**Opción A: Usando Git (si tienes el código en GitHub)**
```bash
cd /home
git clone tu-repositorio crypto-bot
cd crypto-bot
```

**Opción B: Usando SCP/FTP**
```bash
# En tu computadora local:
scp -r crypto-bot root@tu-ip-vps:/home/

# Luego en el VPS:
cd /home/crypto-bot
```

**Opción C: Subir manualmente con FileZilla/WinSCP**
- Conectar al VPS por FTP/SFTP
- Subir todos los archivos a `/home/crypto-bot`

### 3️⃣ Instalar dependencias

```bash
cd /home/crypto-bot
npm install
```

### 4️⃣ Configurar API keys

```bash
# Editar archivo .env
nano .env
```

**IMPORTANTE: Configura estas 2 líneas:**
```env
BYBIT_API_KEY=AQUI_TU_API_KEY
BYBIT_API_SECRET=AQUI_TU_API_SECRET
```

Guarda con `Ctrl + O`, Enter, `Ctrl + X`

### 5️⃣ Obtener API Keys de Bybit Testnet

1. Abre: https://testnet.bybit.com
2. Regístrate/inicia sesión
3. Ve a: https://testnet.bybit.com/app/user/api-management
4. Clic en "Create New Key"
5. Activa permisos de **Trading**
6. Copia la **API Key** y **API Secret**
7. Pégalas en el archivo `.env`

### 6️⃣ Solicitar coins de testnet

1. En Bybit Testnet, ve a **Assets → Assets Overview**
2. Clic en **Request Test Coins**
3. Recibirás 10,000 USDT + 1 BTC gratis ✅

### 7️⃣ Ejecutar backtest (opcional pero recomendado)

```bash
npm run backtest
```

Esto te muestra el rendimiento histórico de la estrategia.

### 8️⃣ Iniciar el bot

**Con screen (recomendado):**
```bash
screen -S crypto-bot
npm start
```

Para desconectar sin detener el bot: `Ctrl + A`, luego `D`

Para volver a ver el bot: `screen -r crypto-bot`

**Con PM2 (más avanzado):**
```bash
npm install -g pm2
pm2 start bot.js --name crypto-bot
pm2 logs crypto-bot
```

### 9️⃣ Verificar que funciona

Deberías recibir un mensaje en Telegram como:
```
🤖 BOT INICIADO

💰 Capital: $100.00 USDT
📊 Pares: BTCUSDT, ETHUSDT, SOLUSDT
🎯 Estrategia: Grid Trading + RSI
✅ Sistema operativo 24/7
```

### 🎉 ¡Listo! El bot está operando 24/7

---

## 🔍 Comandos útiles

```bash
# Ver el bot corriendo
screen -r crypto-bot

# Ver logs en tiempo real
tail -f /home/crypto-bot/logs/bot.log

# Detener el bot (dentro de screen)
Ctrl + C

# Ver todos los screens activos
screen -ls

# Matar un screen sin entrar
screen -X -S crypto-bot quit
```

---

## ⚙️ Configuración Rápida

### Cambiar capital inicial
```bash
nano .env
# Busca: INITIAL_CAPITAL=100
# Cambia a: INITIAL_CAPITAL=200
```

### Cambiar pares de trading
```bash
nano .env
# Busca: TRADING_PAIRS=BTCUSDT,ETHUSDT,SOLUSDT
# Agrega más: TRADING_PAIRS=BTCUSDT,ETHUSDT,SOLUSDT,BNBUSDT,ADAUSDT
```

Después de cualquier cambio, reinicia el bot:
```bash
screen -r crypto-bot
# Presiona Ctrl + C
npm start
```

---

## 🚨 Solución de Problemas

### "Error: Cannot find module"
```bash
cd /home/crypto-bot
npm install
```

### "Error connecting to Bybit"
- Verifica que las API keys sean correctas en `.env`
- Verifica que sean del **TESTNET**, no del mainnet
- Asegúrate de que `BYBIT_TESTNET=true` en `.env`

### No recibo mensajes de Telegram
- El token ya está configurado correctamente
- Asegúrate de haber iniciado conversación con el bot @tu_bot en Telegram
- Verifica que `TELEGRAM_CHAT_ID=1766125504` sea correcto

### "Permission denied"
```bash
cd /home/crypto-bot
chmod +x bot.js
```

---

## 📞 Soporte Rápido

**Ver errores:**
```bash
tail -50 /home/crypto-bot/logs/error.log
```

**Ver trades ejecutados:**
```bash
tail -20 /home/crypto-bot/logs/trades.json
```

**Reiniciar el bot:**
```bash
screen -r crypto-bot
# Ctrl + C para detener
npm start
# Ctrl + A, D para desconectar
```

---

## 📚 Próximos Pasos

1. ✅ Deja el bot corriendo en testnet por 2-3 días
2. ✅ Monitorea los resultados en Telegram
3. ✅ Revisa los logs regularmente
4. ✅ Ajusta configuración según resultados
5. ⚠️ Solo después de estar 100% seguro, considera pasar a mainnet

---

**¿Necesitas más ayuda?** Revisa el README.md completo:
```bash
cat /home/crypto-bot/README.md
```
